# Enerlastic GPU Agent for Windows 11
# ====================================
# Real-time GPU telemetry and power optimization with DeepOptiFlex

🚀 **QUICK START**
```powershell
# Run as Administrator!
.\install.ps1
```

## What's Included

- **GPU Agent**: Real-time telemetry from your NVIDIA GPU
- **Power Optimizer**: DeepOptiFlex profiles for 20-30% energy savings
- **Load Simulator**: Test optimization with simulated workloads
- **SLAshield**: Automatic performance protection

## System Requirements

- Windows 11
- NVIDIA GPU (RTX 3000/4000 series recommended)
- Python 3.10 or higher
- NVIDIA drivers with nvidia-smi
- Administrator privileges (for power control)

## Installation

### Option 1: Automated Install (Recommended)

1. Right-click PowerShell → "Run as Administrator"
2. Navigate to this folder
3. Run:
   ```powershell
   Set-ExecutionPolicy -Scope Process -ExecutionPolicy Bypass
   .\install.ps1
   ```

### Option 2: Manual Install

```powershell
# Install Python dependencies
pip install -r requirements.txt

# For load simulator (optional, requires CUDA)
pip install torch --index-url https://download.pytorch.org/whl/cu121
```

## Configuration

Edit `config.yaml` before first run:

```yaml
agent:
  api_key: "YOUR_API_KEY_HERE"  # Get from app.enerlastic.com
```

Or set environment variable:
```powershell
$env:ENERLASTIC_API_KEY = "your-api-key"
```

## Running the Agent

```powershell
# Start the agent (as Administrator)
python -m agent

# With custom config
python -m agent --config config.yaml

# Debug mode
python -m agent --debug
```

## Running the Load Simulator

```powershell
# Training workload (high sustained GPU)
python -m simulator.llm_load --mode training --duration 300

# Inference workload (bursty pattern)
python -m simulator.llm_load --mode inference --duration 300

# Mixed workload (alternating phases)
python -m simulator.llm_load --mode mixed --duration 600
```

## Expected Results

| Mode | Power Savings | Performance Impact |
|------|---------------|-------------------|
| Eco | 25-30% | ~5% |
| Balanced | 15-20% | ~3% |
| Performance | 0% | 0% |

## Troubleshooting

### "NVML Init Error"
- Ensure NVIDIA drivers are installed and up-to-date
- Restart your computer after driver updates

### "Permission Denied"
- Run PowerShell as Administrator
- nvidia-smi power control requires elevated privileges

### "Connection Error"
- Check internet connectivity
- Verify firewall allows outbound HTTPS (port 443)
- Ensure `app.enerlastic.com` is accessible

### "API Key Invalid"
- Register at app.enerlastic.com to get your API key
- Check that the key is correctly set in config.yaml

## Support

- 📧 Email: support@enerlastic.com
- 🌐 Web: https://app.enerlastic.com
- 📖 Docs: https://docs.enerlastic.com

---
© 2026 Enerlastic - GPU Power Optimization Platform
