@echo off
setlocal EnableDelayedExpansion

:: ============================================
:: Enerlastic GPU Agent Installer for Windows 11
:: ============================================

title Enerlastic GPU Agent Installer

echo.
echo ╔══════════════════════════════════════════════════════════╗
echo ║                                                          ║
echo ║           ENERLASTIC GPU AGENT INSTALLER                 ║
echo ║           GPU Power Optimization Platform                ║
echo ║                                                          ║
echo ╚══════════════════════════════════════════════════════════╝
echo.

:: Check for Administrator
net session >nul 2>&1
if %errorlevel% neq 0 (
    echo [ERROR] This script must be run as Administrator!
    echo.
    echo Right-click install.bat and select "Run as administrator"
    echo.
    pause
    exit /b 1
)

echo [OK] Running as Administrator
echo.

:: Check Python
echo Checking Python installation...
python --version >nul 2>&1
if %errorlevel% neq 0 (
    echo [ERROR] Python not found!
    echo Please install Python 3.10+ from https://www.python.org/downloads/
    echo.
    pause
    exit /b 1
)
for /f "tokens=2" %%a in ('python --version 2^>^&1') do set PYVER=%%a
echo [OK] Python %PYVER% found
echo.

:: Check nvidia-smi
echo Checking NVIDIA GPU...
nvidia-smi --query-gpu=name --format=csv,noheader >nul 2>&1
if %errorlevel% neq 0 (
    echo [ERROR] NVIDIA GPU not detected!
    echo Ensure NVIDIA drivers are installed.
    echo.
    pause
    exit /b 1
)
for /f "delims=" %%a in ('nvidia-smi --query-gpu=name --format=csv,noheader') do set GPUNAME=%%a
echo [OK] GPU detected: %GPUNAME%
echo.

:: Install Python dependencies
echo Installing Python dependencies...
pip install -r requirements.txt --quiet
if %errorlevel% neq 0 (
    echo [WARNING] Some dependencies may have failed
) else (
    echo [OK] Dependencies installed
)
echo.

:: Create .env file if it doesn't exist
if not exist .env (
    echo Creating .env file...
    echo # Enerlastic GPU Agent Configuration> .env
    echo # Get your API key from: https://app.enerlastic.com/settings/api>> .env
    echo.>> .env
    echo ENERLASTIC_API_KEY=>> .env
    echo.>> .env
    echo # Agent metadata (edit these values)>> .env
    echo AGENT_NAME=My GPU Agent>> .env
    echo GPU_TYPE=%GPUNAME%>> .env
    echo DATACENTER_ID=>> .env
    echo RACK_ID=>> .env
    echo SERVER_ID=>> .env
    echo.>> .env
    echo [OK] Created .env file
) else (
    echo [OK] .env file already exists
)
echo.

:: Optionally install PyTorch for simulator
echo.
set /p INSTALL_TORCH="Install PyTorch for load simulator? (y/N): "
if /i "%INSTALL_TORCH%"=="y" (
    echo Installing PyTorch (this may take a few minutes)...
    pip install torch --index-url https://download.pytorch.org/whl/cu121 --quiet 2>nul
    if %errorlevel% neq 0 (
        echo [WARNING] PyTorch installation failed (simulator won't work)
    ) else (
        echo [OK] PyTorch installed
    )
)
echo.

:: Create start scripts
echo Creating start scripts...

echo @echo off> start-agent.bat
echo title Enerlastic GPU Agent>> start-agent.bat
echo echo Starting Enerlastic GPU Agent...>> start-agent.bat
echo echo.>> start-agent.bat
echo python -m agent --config config.yaml>> start-agent.bat
echo pause>> start-agent.bat

echo @echo off> start-simulator.bat
echo title LLM Load Simulator>> start-simulator.bat
echo echo Starting LLM Load Simulator...>> start-simulator.bat
echo echo.>> start-simulator.bat
echo set /p MODE="Select mode (training/inference/mixed) [mixed]: ">> start-simulator.bat
echo if "%%MODE%%"=="" set MODE=mixed>> start-simulator.bat
echo set /p DURATION="Duration in seconds [300]: ">> start-simulator.bat
echo if "%%DURATION%%"=="" set DURATION=300>> start-simulator.bat
echo echo.>> start-simulator.bat
echo python -m simulator.llm_load --mode %%MODE%% --duration %%DURATION%%>> start-simulator.bat
echo pause>> start-simulator.bat

echo [OK] Start scripts created
echo.

:: Done
echo ╔══════════════════════════════════════════════════════════╗
echo ║                                                          ║
echo ║           INSTALLATION COMPLETE!                         ║
echo ║                                                          ║
echo ╚══════════════════════════════════════════════════════════╝
echo.
echo NEXT STEPS:
echo.
echo   1. Edit .env file with your API key and agent metadata
echo      Get your key from: https://app.enerlastic.com/settings/api
echo.
echo   2. Double-click "start-agent.bat" to run the agent
echo.
echo   3. (Optional) Double-click "start-simulator.bat" to test
echo.
echo For help: https://docs.enerlastic.com
echo.
pause
